/* Ideja:
 * BFS + kombinatorna prebrojavanja
 */

#include <cstdio>
#include <vector>
#include <queue>
#include <memory.h>
using namespace std;

#define pb push_back
#define MOD 1000000007
#define pascalN 5000
#define pascalK 301

struct entry
{
    vector <int> susJed;
} G[55555]; // 55551

queue <int> Q;

bool visited[55555];
int matrix[pascalK][pascalN];

int n, k, a, b;
int dubina, sz, currSize, ispravnihGrana;
int res = 0, node;

int main()
{
    // #dbg
    //freopen( "test.txt", "r", stdin );

    // precalc pascal
    for( int i = 0; i < pascalN; i++ )
        matrix[0][i] = 1;
    for( int i = 0; i < pascalK; i++ )
        matrix[i][0] = 1;

    for( int i = 1; i < pascalK; i++ )
        for( int j = 1; j < pascalN; j++ )
        {
            matrix[i][j] = matrix[i - 1][j] + matrix[i][j - 1];

            if( matrix[i][j] > MOD )
                matrix[i][j] %= MOD;
        }
    /*
    // # dbg !!
    for ( int i = 0; i < 8; i++ )
    {
        for( int j = 0; j < 8; j++ )
            printf( "%5d ", matrix[i][j] );
        printf("\n");
    }
    */


    scanf( "%d %d", &n, &k );

    for( int i = 0; i < n - 1; i++ )
    {
        scanf( "%d %d", &a, &b );

        G[a].susJed.pb( b );
        G[b].susJed.pb( a );
    }

    k--; // smanji k jer se "center cvor" broji

    for( int i = 1; i <= n; i++ ) // za svaki cvor prebroj pauke
    {
        sz = G[i].susJed.size();

        //printf( "BLA: %d\n", i );

        while( !Q.empty() ) // isprazni Q
            Q.pop();

        //if( sz < k ) // optimizacija
          //  continue;

        dubina = 1;

        memset( visited, 0, sizeof( visited ) ); // fix dis if possible

        visited[i] = 1;
        Q.push( i ); // ubaci "center cvor"

        while( k / dubina >= 3 ) // dok god je moguce formirati pauka do odredjene dubine
        {
            // za svaku dubinu racunaj broj grana koji dopire on centra do te dubine
            sz = Q.size();
            for ( int j = 0; j < sz; j++ )
            {
                node = Q.front();
                Q.pop();

                int vecSz = G[node].susJed.size();

                for( int l = 0; l < vecSz; l++ )
                {
                    if( !visited[G[node].susJed[l]] )
                    {
                        visited[G[node].susJed[l]] = 1;
                        Q.push( G[node].susJed[l] );
                    }
                }
            }

            ispravnihGrana = Q.size();
            // $dbg
            //printf( "Q size: %d NODE: %d\n", ispravnihGrana, i );

            //if( ispravnihGrana < k / dubina ) // ako vec na ovom nivou nije moguce napraviti pauka, preskoci na sledeci cvor
              //  break;

            if( ispravnihGrana < ( k / dubina ) )
            {
                dubina++;
                continue;
            }

            if( ispravnihGrana % ( k / dubina ) )
            {
                dubina++;
                break;
            }

            res = ( res + matrix[k / dubina][ispravnihGrana - ( k / dubina )] ) % MOD;

            //printf( "RES: %d NODE: %d\n", res, i );

            //printf( "K/D: %d isprG: %d field: %d\n", k / dubina, ispravnihGrana, matrix[k / dubina][ispravnihGrana - ( k / dubina )] );

            dubina++; // povecaj dubinu

            // #dbg
            //printf( "DUB: %d\n", dubina );
        }
    }

    printf( "%d\n", res + 1 );

    return 0;
}
