#include <cstdio>
#include <cstdlib>
#include <algorithm>

using namespace std;

struct sekvoja
{
    int x;
    int h;
};

inline long long absolute(long long x)
{
    if (x>0) return x;
    return -x;
}
inline bool compByHeightAscending(sekvoja a, sekvoja b)
{
    return a.h<b.h;
}
inline bool compByHeightDescending(sekvoja a, sekvoja b)
{
    return a.h>b.h;
}
inline bool compByX(sekvoja a, sekvoja b)
{
    return a.x<b.x;
}

sekvoja tree[10010];
int treeStart[10010];
int n, zTreeCount, bTreeCount;
sekvoja mTree;
int mTreePos;
long long minDist = 0;
long long minTime = 0;
bool timeFound = false;

inline void calculateDistance(int p)
{
    long long tmpDist = 0;
    long long startPos = tree[p].x;
    long long lx = startPos;
    long long rx = startPos;
    int mTreeLeft = p-mTreePos;
    /*
    printf("mtreeleft %d", mTreeLeft);
    printf("found tree with same position at position %d\n", p);
    printf("Start pos: %d\n", startPos);
    */
    if (mTreeLeft>0)
    {
        for (int i=p-1; i>=mTreePos; i--)
        {
            lx -= tree[i+1].h;
            tmpDist += absolute(tree[i].x - lx);
        }
        for (int i=mTreePos-1; i>=0; i--)
        {
            lx -= tree[i].h;
            tmpDist += absolute(tree[i].x - lx);
        }
        for (int i=p+1; i<n; i++)
        {
            rx += tree[i].h;
            tmpDist += absolute(tree[i].x - rx);
        }
    }
    else if (mTreeLeft==0)
    {
        for (int i=p-1; i>=0; i--)
        {
            lx-= tree[i].h;
            tmpDist += absolute(tree[i].x - lx);
        }
        for (int i=p+1; i<n; i++)
        {
            rx += tree[i].h;
            tmpDist += absolute(tree[i].x - rx);
        }
    }
    else if (mTreeLeft<0)
    {
        for (int i=p-1; i>=0; i--)
        {
            lx-=tree[i].h;
            tmpDist += absolute(tree[i].x - lx);
        }
        for (int i=p+1; i<=mTreePos; i++)
        {
            rx += tree[i-1].h;
            tmpDist += absolute(tree[i].x - rx);
        }
        for (int i=mTreePos+1; i<n; i++)
        {
            rx += tree[i].h;
            tmpDist += absolute(tree[i].x - rx);
        }
    }
    //printf("temp dist is %d\n", tmpDist);
    if ((timeFound==false)||(tmpDist<minTime))
    {
        minTime = tmpDist;
        timeFound = true;
    }

}

int main()
{
    //freopen("sekvoja.in", "r", stdin);
    mTree.h = 1000000000;
    scanf("%d", &n);
    for (int i=0; i<n; i++)
        scanf("%d %d", &tree[i].x, &tree[i].h);

    sort(tree, tree+n, compByX);

    for (int i=0; i<n; i++)
    {
        treeStart[i] = tree[i].h;
        minDist += tree[i].h;
        if (tree[i].h<mTree.h)
        {
            mTree = tree[i];
            mTreePos = i;
        }
    }

/*
    for (int i=0; i<mTreePos; i++)
        zTree[i] = tree[i];
*/
    zTreeCount = mTreePos;
/*
    for (int i=mTreePos+1; i<n; i++)
        bTree[i-mTreePos-1] = tree[i];
*/
    bTreeCount = n-mTreePos-1;

    sort(tree, tree+zTreeCount, compByHeightDescending);
    sort(tree+zTreeCount+1, tree+n, compByHeightAscending);


    for (int i=0; i<n; i++)
        if (tree[i].h == treeStart[i])
            calculateDistance(i);

    printf("%lld\n", minTime);
/*
    printf("lazina sekvoja:\n\tid: %d\tx: %d\th: %d\n", mTreePos, mTree.x, mTree.h);

    printf("zikine sekvoje: \n");
    for (int i=0; i<zTreeCount; i++)
        printf("\tid: %d\tx: %d\th: %d\n", i, tree[i].x, tree[i].h);
    printf("bozine sekvoje: \n");
    for (int i=0; i<bTreeCount; i++)
        printf("\tid: %d\tx: %d\th: %d\n", i, tree[i+zTreeCount+1].x, tree[i+zTreeCount+1].h);
*/
}
