#include <cstdio>
#include <cstdlib>
#include <algorithm>
#include <vector>
using namespace std;
vector<int> vertex[16000];
int visited[16000];
bool completed[16000] = {0};
int paths[16000];
int conn[16000] = {0};
int bfsQueue[16000] = {0};
int n, k;
int tmp1, tmp2;
int top[300];
int bot[300];
unsigned long long int number_of_spiders = 0;
vector<int> divisors;
int gcd(int a, int b)
{
    if (a==b) return a;
    if (b==1) return 1;
    if (b>a) swap(a,b);
    int r;
    r = a % b;
    if (r==0) return b;
    while (r)
    {
        b = r;
        r = a % b;
    }
    return b;
}
inline void testprint(){
    for (int i=1; i<=n; i++)
    {
        for (int j=0; j<vertex[i].size(); j++)
            printf("%d ", vertex[i].at(j));
        printf("\n");
    }
}
inline void get_data(){
    scanf("%d %d", &n, &k);
    for (int i=1;i<n; i++)
    {
        scanf("%d %d", &tmp1, &tmp2);
        vertex[tmp1].push_back(tmp2);
        vertex[tmp2].push_back(tmp1);
        conn[tmp1]++;
        conn[tmp2]++;
    }
}
inline void find_divisors(){
    --k;
    divisors.push_back(k);
    for (int i=k/2; i>=3; i--)
        if (k%i==0) divisors.push_back(i);
}
void bfs(int start){
    for (int i=0; i<16000; i++)
    {
        visited[i] = -1;
        paths[i] = 0;
    }
    int queuePos = 0;
    bfsQueue[queuePos] = start;
    int queueCount = 1;
    visited[start] = 0;
    while (queuePos<queueCount)
    {
        int curr = bfsQueue[queuePos];
        for (int i=0; i<conn[curr]; i++)
            if (visited[vertex[curr].at(i)]==-1)
            {
                visited[vertex[curr].at(i)] = visited[curr]+1;
                paths[visited[curr]+1]++;
                bfsQueue[queueCount++]=vertex[curr].at(i);
            }
        queuePos++;

    }

}
int countSpiders(int have, int need)
{
    unsigned long long int tmp;
    int x;
    if (have<need) return 0;
    if (have == need) return 1;
    //printf("have: %d; need: %d;\n", have, need);
    int topCnt = need;
    int botCnt = topCnt;
    int pos=0;
    for (int i=0; i<topCnt; i++) top[i] = have-i;
    for (int i=0; i<botCnt; i++) bot[i] = i+1;
    /*
    //simple
    unsigned long long topTotal = 1;
    unsigned long long botTotal = 1;
    for (int i=0; i<topCnt; i++) topTotal*=top[i];
    for (int i=0; i<botCnt; i++) botTotal*=bot[i];
    */
    //speed = ?
    //anti-overflow
    for (int i=0; i<topCnt; i++)
        for (int j=0; i<botCnt; i++)
        {
            x = gcd(top[i], bot[j]);
            top[i]/=x;
            bot[j]/=x;
        }

    unsigned long long topTotal = 1;
    unsigned long long botTotal = 1;
    for (int i=0; i<topCnt; i++)
    {
        tmp = top[i];
        topTotal*=tmp;
        tmp = bot[i];
        botTotal*=tmp;
    }

    return topTotal/botTotal;

}
inline void find(int x){
    //finds all vectors with at least x connections
    //and checks whether they can make (a) spider(s)
    for (int i=1; i<=n; i++)
        if ((conn[i]>=x)&&(completed[i]==false))
            {
                completed[i] = true;
                bfs(i);
                for (int j=divisors.size()-1;j>=0; j--)
                {
                    int paths_needed = divisors.at(j);
                    int paths_available = paths[k/paths_needed];
                    /*
                    printf("Checking for vertex #%d; ", i);
                    printf("paths needed: %d\npaths available: %d\n", paths_needed, paths_available);
                    printf("--\n");
                    */
                    number_of_spiders += countSpiders(paths_available, paths_needed);
                    number_of_spiders %= 1000000007;

                }
            }
}

int main()
{
    get_data();
    find_divisors();

    for (int dv=divisors.size()-1; dv>=0; dv--) find(divisors.at(dv));

    printf("%ulld\n", number_of_spiders);
    return 0;
}
