#include <set>
#include <cstdio>
#include <vector>
#include <algorithm>

using namespace std;

const int max_v = 2e4 + 24;
const int max_e = 2e5 + 25;
const int oo = 0x3f3f3f3f;

struct edge
{
  int node, cost, dist, idx;
  edge(){}
  edge(int _node, int _cost, int _dist, int _idx) : node(_node), cost(_cost), dist(_dist), idx(_idx){}
};

struct node
{
  int nxt, dst;
  node(){}
  node(int _nxt, int _dst) : nxt(_nxt), dst(_dst) {}
  bool operator < (const node &A) const
  {
    if (dst != A.dst) return dst < A.dst;
    return nxt != A.nxt;
  }
};

struct data
{
  int a, b, c, id;
  data(){};
  data(int _a, int _b, int _c, int _id) : a(_a), b(_b), c(_c), id(_id) {}
  bool operator < (const data &A) const
  {
    return c < A.c;
  }
};

struct disjoint_set
{
  int root[max_v], rank[max_v];
  void init() {for (int i = 0; i < max_v; i++) root[i] = i;}
  int find(int x) {return x == root[x] ? x : root[x] = find(root[x]);}
  bool merge(int a, int b)
  {
    a = find(a);
    b = find(b);
    if (a == b) return false;
    if (rank[a] > rank[b]) root[b] = a;
    else root[a] = b;
    if (rank[a] == rank[b]) rank[b]++;
    return true;
  }
} ds;

int V, E, x, y, c, d, d0[max_v];
bool mark[max_v], vis[max_v];
vector<edge> adj[max_v];
vector<data> niz;
set<node> pq;

void dfs(int curr)
{
  vis[curr] = true;
  for (vector<edge>::iterator it = adj[curr].begin(); it != adj[curr].end(); it++)
    if (!vis[it->node])
    {
      dfs(it->node);
      if (mark[it->idx]) printf("%d ", it->idx + 1);
    }
}

void dijkstra()
{
  for (int i = 0; i < V; i++) d0[i] = oo;
  *d0 = 0;
  pq.insert(node(0, 0));
  for (; !pq.empty(); pq.erase(pq.begin()))
  {
    int curr = pq.begin()->nxt;
    int dst = pq.begin()->dst;
    for (vector<edge>::iterator it = adj[curr].begin(); it != adj[curr].end(); it++)
      if (d0[it->node] > dst + it->dist)
      {
        if (d0[it->node] != oo) pq.erase(node(it->node, d0[it->node]));
        pq.insert(node(it->node, d0[it->node] = dst + it->dist));
      }
  }
}

int main()
{
  //freopen("input.in", "r", stdin);
  scanf("%d %d", &V, &E);
  ds.init();
  for (int i = 0; i < E; i++)
  {
    scanf("%d %d %d %d", &x, &y, &c, &d);
    x--, y--;
    adj[x].push_back(edge(y, c, d, i));
    adj[y].push_back(edge(x, c, d, i));
    niz.push_back(data(x, y, c, i));
  }
  dijkstra();
  for (int i = 0; i < niz.size(); i++) niz[i].c += d0[niz[i].a] + d0[niz[i].b];
  sort(niz.begin(), niz.end());
  printf("%d\n", V - 1);
  for (int i = 0; i < niz.size(); i++)
    if (ds.merge(niz[i].a, niz[i].b)) mark[niz[i].id] = true;
  dfs(0);
  return 0;
}
