#include <map>
#include <cstdio>
#include <vector>

using namespace std;

const int max_v = 2e4 + 24;
const int max_k = 222;
const int MOD = 1e9 + 7;

struct data
{
  int cnt[max_k];
  data(){for (int i = 0; i < max_k; i++) cnt[i] = 0;}
};

int V, k, x, y, cnt[max_v][max_k];
long long ret, ncr[max_v][max_k];
vector<pair<int, data> > adj[max_v];
map<pair<int, int>, int> idx;

void dfs(int curr = 0, int prev = -1)
{
  cnt[curr][0] = 1;
  for (vector<pair<int, data> >::iterator it = adj[curr].begin(); it != adj[curr].end(); it++)
    if (it->first != prev)
    {
      dfs(it->first, curr);
      for (int i = 1; i < k; i++)
      {
        it->second.cnt[i] = bool(cnt[it->first][i - 1]);
        cnt[curr][i] += bool(cnt[it->first][i - 1]);
      }
    }
}

void dfs_rev(int curr = 0, int prev = -1)
{
  if (~prev)
  {
    int id = idx[make_pair(prev, curr)];
    for (int i = 1; i < k; i++)
      if (cnt[prev][i - 1] > 1 || (cnt[prev][i - 1] == 1 && adj[prev][id].second.cnt[i - 1] == 0)) cnt[curr][i]++;
  }
  for (vector<pair<int, data> >::iterator it = adj[curr].begin(); it != adj[curr].end(); it++)
    if (it->first != prev) dfs_rev(it->first, curr);
}

int main()
{
  //freopen("input.in", "r", stdin);
  //freopen("moje.out", "w", stdout);
  scanf("%d %d", &V, &k);
  for (int i = 0; i < max_v; i++)
  {
    ncr[i][0] = 1;
    for (int j = 1; j < max_k; j++) ncr[i][j] = (ncr[i - 1][j] + ncr[i - 1][j - 1]) % MOD;
  }
  for (int i = 1; i < V; i++)
  {
    scanf("%d %d", &x, &y);
    adj[--x].push_back(make_pair(--y, data()));
    adj[y].push_back(make_pair(x, data()));
    idx[make_pair(x, y)] = adj[x].size() - 1;
    idx[make_pair(y, x)] = adj[y].size() - 1;
  }
  dfs();
  dfs_rev();
  for (int i = 0; i < V; i++)
    for (int len = 1; len < k; len++) if ((k - 1) % len == 0)
    {
      int need = (k - 1) / len;
      if (need < 3) continue;
      ret = (ret + ncr[cnt[i][len]][need]) % MOD;
    }
  printf("%d\n", ret);
  return 0;
}
