#include <cstdio>
#include <cstring>
#include <algorithm>
#include <vector>
using namespace std;

struct poligon;
struct tacka;
poligon konveksni(vector <tacka> A);

long long Xt,Yt;

inline long long kv(long long x){
    return x*x;
}

struct tacka{
    long long x,y;
    inline friend tacka operator +(tacka a,tacka b){
        tacka tmp;
        tmp.x = a.x+b.x;
        tmp.y = a.y+b.y;
        return tmp;
    }
    inline friend tacka operator -(tacka a,tacka b){
        tacka tmp;
        tmp.x = a.x-b.x;
        tmp.y = a.y-b.y;
        return tmp;
    }
    inline friend bool operator <(tacka a,tacka b){
        return a.x<b.x || (a.x == b.x && a.y < b.y);
    }
};

bool cmp_dist(tacka a,tacka b){
    return (kv(a.x-Xt)+kv(a.y-Yt)) < (kv(b.x-Xt)+kv(b.y-Yt));
}

struct poligon{
    vector <tacka> A;
    inline friend poligon operator +(poligon a,poligon b){
        vector <tacka> A2;
        int i,j;
        for (i=0; i<a.A.size(); i++){
            for (j=0; j<b.A.size(); j++){
                A2.push_back(a.A[i] + b.A[j]);
            }
        }
        return konveksni(A2);
    }
    void ispisi(){
        int i,j;
        j = A.size();
        printf("tacaka = %d\n",j);
        for (i=0; i<j; i++) printf("%I64d %I64d\n",A[i].x,A[i].y);
    }
};

bool levo_skretanje(tacka a,tacka b,tacka c){
    return (a.x*b.y + b.x*c.y + c.x*a.y - a.y*b.x - b.y*c.x - c.y*a.x) > 0;
}

tacka Gore[100005],Dole[100005];

void eliminisi(poligon &P){
    sort(P.A.begin(),P.A.end(),cmp_dist);
    P.A.resize(13);
    P = konveksni(P.A);
}


poligon konveksni(vector <tacka> A){
    poligon tmp;
    sort(A.begin(),A.end());
    //for (int i=0; i<A.size(); i++) printf("> %I64d %I64d\n",A[i].x,A[i].y);
    int i,dh=0,gh=0;
    for (i=0; i<A.size(); i++){
        while (dh>1){
            if (!levo_skretanje(Dole[dh-1],Dole[dh],A[i])){
                dh--;
            } else {
                break;
            }
        }
        Dole[++dh] = A[i];
    }
    reverse(A.begin(),A.end());
    for (i=0; i<A.size(); i++){
        while (gh>1){
            if (!levo_skretanje(Gore[gh-1],Gore[gh],A[i])){
                gh--;
            } else {
                break;
            }
        }
        Gore[++gh] = A[i];
    }
    //printf("%d %d\n",dh,gh);
    for (i=1; i<dh; i++) tmp.A.push_back(Dole[i]);
    for (i=1; i<gh; i++) tmp.A.push_back(Gore[i]);
    return tmp;
}

bool tacka_unutra(tacka x,poligon f){
    int i,sz;
    sz = f.A.size();
    if (levo_skretanje(x,f.A[0],f.A[sz-1])) return false;
    for (i=1; i<sz; i++) if (levo_skretanje(x,f.A[i],f.A[i-1])) return false;
    return true;
}

poligon Ulazni[10005],heuristicni;
tacka nub;
int N;

//ovaj zadatak idemo sve ili nista

int main(){
    int x1,x2,y1,y2,t,i,sol,pok;
    scanf("%d%d%d%d",&x1,&y1,&x2,&y2);
    Xt = x2-x1;
    Yt = y2-y1;
    scanf("%d",&N);
    for (i=1; i<=N; i++){
        scanf("%d",&t);
        while (t--){
            scanf("%d%d",&x2,&y2);
            nub.x = x2;
            nub.y = y2;
            Ulazni[i].A.push_back(nub);
        }
    }
    nub.x = Xt;
    nub.y = Yt;
    pok=1;
    sol=1;
    heuristicni = Ulazni[1];
    while (!tacka_unutra(nub,heuristicni)){
        pok++;
        if (pok>N) pok=1;
        sol++;
        heuristicni = heuristicni + Ulazni[pok];
    }
    printf("%d\n",sol);
    return 0;
}



