#include <iostream>
#include <cstdio>

inline long long max(long long a, long long b){return a>b?a:b;}
inline long long abs(long long a){return a>0?a:-a;}

struct Sekvoja
{
       int pos, h;
       
       void operator=(Sekvoja b)
       {
            pos = b.pos;
            h = b.h;
       }
};

Sekvoja data[100010];
long long res = -1;

void open_the_door(int a, int b)
{
     if(a==b) return;
     Sekvoja p = data[a];
     data[a] = data[b];
     data[b] = p;
}

long long get_on_the_floor(int n)
{
     long long min = -1;
     for(int i=0;i<n;i++)
     {
             long long sum = 0;
             long long cpos = data[i].pos;
             int ch = data[i].h;
             for(int j=i-1;j>=0;j--)
             {
                     cpos -= max(ch,data[j].h);
                     ch = data[j].h;
                     sum += abs(cpos-data[j].pos);
             }
             cpos = data[i].pos;
             ch = data[i].h;
             for(int j=i+1;j<n;j++)
             {
                     cpos += max(ch,data[j].h);
                     ch = data[j].h;
                     sum += abs(cpos-data[j].pos);
             }
             if(sum < min || min < 0) min = sum;
     }
     return min;
}

void everybody_walk_the_dinosaur_right(int i, int n)
{
     if(i>=n)
     {
               long long ctime = get_on_the_floor(n);
               if(ctime < res || res < 0) res = ctime;
               return;
     }
     for(int k=i;k<n;k++)
     {
             open_the_door(i,k);
             everybody_walk_the_dinosaur_right(i+1,n);
             open_the_door(i,k);
     }
}

void everybody_walk_the_dinosaur_left(int i, int minpos, int n)
{
     if(i == minpos)
     {
            everybody_walk_the_dinosaur_right(i+1,n);
            return;
     }
     for(int k=i;k<minpos;k++)
     {
             open_the_door(i,k);
             everybody_walk_the_dinosaur_left(i+1,minpos,n);
             open_the_door(i,k);
     }
}

int main()
{
    int n;
    scanf("%d", &n);
    int minpos = 0;
    for(int i=0;i<n;i++)
    {
            scanf("%d%d", &data[i].pos, &data[i].h);
            if(data[i].h < data[minpos].h) minpos = i;
    }
    everybody_walk_the_dinosaur_left(0,minpos,n);
    printf("%lld", res);
    //system("pause");
    return 0;
}
