program sekvoje;

var lowest, lowestpos, n, i: longint;
    x, h: array[1..100001] of longint;
    eff: array[1..100001] of int64;
    total, mid: int64;

procedure quicksortup(l, r: longint);
var i, j, pivot, tmp: longint;
begin
  i := l;
  j := r;
  pivot := h[(i + j) div 2];
  repeat
    while h[i] < pivot do inc(i);
    while h[j] > pivot do dec(j);
    if i <= j then
    begin
      tmp := h[i];
      h[i] := h[j];
      h[j] := tmp;

      tmp := x[i];
      x[i] := x[j];
      x[j] := tmp;

      inc(i);
      dec(j);
    end
  until i >= j;

  if i < r then quicksortup(i, r);
  if j > l then quicksortup(l, j);
end;

procedure quicksortdown(l, r: longint);
var i, j, pivot, tmp: longint;
begin
  i := l;
  j := r;
  pivot := h[(i + j) div 2];
  repeat
    while h[i] > pivot do inc(i);
    while h[j] < pivot do dec(j);
    if i <= j then
    begin
      tmp := h[i];
      h[i] := h[j];
      h[j] := tmp;

      tmp := x[i];
      x[i] := x[j];
      x[j] := tmp;

      inc(i);
      dec(j);
    end
  until i >= j;

  if i < r then quicksortdown(i, r);
  if j > l then quicksortdown(l, j);
end;

procedure quicksort(l, r: longint);
var i, j, pivot, tmp: int64;
begin
  i := l;
  j := r;
  pivot := eff[(i + j) div 2];
  repeat
    while eff[i] < pivot do inc(i);
    while eff[j] > pivot do dec(j);
    if i <= j then
    begin
      tmp := eff[i];
      eff[i] := eff[j];
      eff[j] := tmp;

      inc(i);
      dec(j);
    end
  until i >= j;

  if i < r then quicksort(i, r);
  if j > l then quicksort(l, j);
end;

begin
  lowestpos := 0;
  lowest := 1000000000;
  readln(n);
  for i := 1 to n do
  begin
    readln(x[i], h[i]);
    if h[i] < lowest then
    begin
      lowest := h[i];
      lowestpos := i;
    end;
  end;

  quicksortdown(1, lowestpos - 1);
  quicksortup(lowestpos + 1, n);

  eff[1] := -1000000000000000000;

  for i := 2 to lowestpos do
    eff[i] := eff[i - 1] + h[i - 1];

  for i := lowestpos + 1 to n do
    eff[i] := eff[i - 1] + h[i];

  for i := 1 to n do
    eff[i] := x[i] - eff[i];

  quicksort(1, n);

  mid := eff[(n + 1) div 2];

  total := 0;

  for i := 1 to n do
    total := total + abs(eff[i] - mid);

  writeln(total);

end.