#include <iostream>
#include <cstdio>
#include <cstring>
#include <algorithm>
#include <set>
#include <map>
#include <queue>
#include <deque>
#include <vector>
#include <cmath>
#define msg(__var) cerr << #__var << " = " << __var << endl
using namespace std;

const int MAXN = 100224; //promeni?!?
const int MAXEDGE = 200224;
const long long INF = (1LL << 59);

struct node
{
    int to, idx, cost;
    node() {}
    node(int _to, int _cost, int _idx)
    {
        cost = _cost;
        to = _to;
        idx = _idx;
    }
};

int n, m, from[MAXN], to[MAXN], cost[MAXN], put[MAXN];
long long dist[2][MAXN];
deque<int> dq;
vector<node> graph[MAXN];
bool inQ[MAXN];

void spfa(int source)
{
    for (int i = 0; i <= n; i++)
        dist[0][i] = dist[1][i] = INF;

    dist[0][source] = dist[1][source] = 0;
    dq.push_back(source);
    inQ[source] = true;

    int iter = 0;
    while (!dq.empty())
    {
        iter++;
        int curr = dq.front();
        //msg(curr);
        //if (iter == 30) return;
        dq.pop_front();
        inQ[curr] = false;

        for (int i = 0; i < graph[curr].size(); i++)
        {
            bool flag = false;
            int v = graph[curr][i].to, d = graph[curr][i].cost;
            if (dist[0][curr] + d < dist[0][v])
            {
                dist[0][v] = dist[0][curr] + d;
                flag = true;
            }
            else if (dist[0][curr] + d < dist[1][v])
            {
                dist[1][v] = dist[0][curr] + d;
                flag = true;
            }
            else if (dist[1][curr] + d < dist[1][v])
            {
                dist[1][v] = dist[1][curr] + d;
                flag = true;
            }
            if (dq.empty() && flag) dq.push_back(v);
            else if (flag && !inQ[v])
            {
                inQ[v] = true;
                if (dist[0][v] < dist[0][dq[0]]) dq.push_front(v);
                else dq.push_back(v);
            }
        }
    }
}

struct edge
{
    long long cost;
    int a, b, idx;
    edge() {}
    edge(int _a, int _b, int _idx, long long _cost)
    {
        cost = _cost;
        a = _a; b = _b;
        idx = _idx;
    }
    bool operator<(const edge &other) const
    {
        return (cost < other.cost);
    }
};

priority_queue<edge> PQ;

long long getCost(int &idx)
{
    int a = from[idx], b = to[idx];
    long long costA = put[idx] + dist[0][a];
    long long costB = put[idx] + dist[0][b];
    //msg(b);
    //msg(dist[0][b]);

    if (dist[0][b] == dist[0][a] + cost[idx]) costA += min(dist[0][a] + 2 * cost[idx], dist[1][b]);
    else costA += dist[0][b];
    if (dist[0][a] == dist[0][b] + cost[idx]) costB += min(dist[0][b] + 2 * cost[idx], dist[1][b]);
    else costB += dist[0][a];
    return min(costA, costB);
}

int pa[MAXN], rank[MAXN];

inline int find(int v)
{
    int temp = v;
    while (v != pa[v]) v = pa[v];

    while (temp != v)
    {
        int pathCompress = pa[temp];
        pa[temp] = v;
        temp = pathCompress;
    }

    return v;
}

void merge(int u, int v)
{
    u = find(u);
    v = find(v);

    if (rank[v] > rank[u]) swap(v, u);
    else if (rank[v] == rank[u]) rank[u]++;
    pa[v] = u;
}

bool isChanged[MAXEDGE];

int main()
{
    cin.sync_with_stdio(0); cin.tie(0);
    //freopen("ss.in", "r", stdin);
    cin >> n >> m;
    for (int i = 0; i <= n; i++)
    {
        pa[i] = i;
        rank[i] = 0;
    }
    cout << n - 1 << "\n";
    /*if (n - 1 == m)
    {
        for (int i = 1; i <= m; i++)
            cout << i << " ";
        cout << "\n";
        return 0;
    }*/
    for (int i = 0; i < m; i++)
    {
        cin >> from[i] >> to[i] >> put[i] >> cost[i];
        graph[from[i]].push_back(node(to[i], cost[i], i));
        graph[to[i]].push_back(node(from[i], cost[i], i));
    }
    spfa(1);
    /*for (int i = 1; i <= n; i++)
    {
        cout << dist[0][i] << " " << dist[1][i] << endl;
    }*/
    for (int i = 0; i < m; i++)
        PQ.push(edge(from[i], to[i], i, getCost(i)));

    while (!PQ.empty())
    {
        edge curr = edge(PQ.top());
        //cout << curr.idx << " " << curr.cost << " " << curr.a << " " << curr.b << endl;
        PQ.pop();
        long long tempCost = getCost(curr.idx);
        //msg(tempCost);
        if (tempCost != curr.cost)
        {
            //cout << "KAKO" << endl;
            curr.cost = tempCost;
            PQ.push(curr);
            //cout << curr.cost << " " << tempCost << endl;
            continue;
        }

        int u = curr.a, v = curr.b;
        if (find(u) != find(v))
        {
            merge(u, v);
            cout << curr.idx + 1 << " ";
            isChanged[curr.idx] = true;
            for (int i = 0; i < 2; i++)
                dist[i][u] = dist[i][v] = INF;

            int bug = v;

            for (int i = 0; i <= graph[bug].size(); i++)
            {
                int v = graph[bug][i].to, d = graph[bug][i].cost, idx = graph[bug][i].idx;
                if (isChanged[idx]) d *= 2;

                if (dist[0][v] + d < dist[0][bug])
                {
                    dist[0][bug] = dist[0][v] + d;
                    //flag = true;
                }
                else if (dist[0][v] + d < dist[1][bug])
                {
                    dist[1][bug] = dist[0][v] + d;
                    //flag = true;
                }
                else if (dist[1][v] + d < dist[1][bug])
                {
                    dist[1][bug] = dist[1][v] + d;
                    //flag = true;
                }
            }

            bug = u;
            for (int i = 0; i <= graph[bug].size(); i++)
            {
                int v = graph[bug][i].to, d = graph[bug][i].cost, idx = graph[bug][i].idx;
                if (isChanged[idx]) d *= 2;

                if (dist[0][v] + d < dist[0][bug])
                {
                    dist[0][bug] = dist[0][v] + d;
                    //flag = true;
                }
                else if (dist[0][v] + d < dist[1][bug])
                {
                    dist[1][bug] = dist[0][v] + d;
                    //flag = true;
                }
                else if (dist[1][v] + d < dist[1][bug])
                {
                    dist[1][bug] = dist[1][v] + d;
                    //flag = true;
                }
            }
        }
    }
    cout << "\n";
    return 0;
}
