#include <iostream>
#include <cstdio>
#include <set>
#include <map>
#include <queue>
#include <vector>
#include <string>
#include <cstring>
#include <cmath>
#include <ctime>
#include <algorithm>
#define msg(__var) cerr << #__var << " = " << __var << endl
using namespace std;

const int MAXN = 16224;
const int MAXK = 224;
const int MOD = (int)(1e9 + 7);

int choose[MAXN][MAXK];
int n, k;
vector<int> graph[MAXN];
int ans = 0;
int toReset[MAXN * 2];
bool mark[MAXN];

void doPascal()
{
    for (int i = 0; i < MAXN; i++)
        choose[i][0] = 1;

    for (int i = 1; i < MAXN; i++)
        for (int j = 1; j <= min(i, MAXK - 1); j++)
        {
            choose[i][j] = choose[i - 1][j - 1] + choose[i - 1][j];
            if (choose[i][j] >= MOD) choose[i][j] -= MOD;
        }
}

int GlobalMax = 0, resetSz = 0;
void calcMax(int curr, int currL)
{
    GlobalMax = max(GlobalMax, currL);
    if (GlobalMax > k + 2) return;

    mark[curr] = true;
    toReset[resetSz++] = curr;

    for (int i = 0; i < graph[curr].size(); i++)
    {
        int v = graph[curr][i];
        if (!mark[v]) calcMax(v, currL + 1);
    }
}

int OMG[MAXK + 10], chainLengths[MAXN * 2], chainSz = 0;
void calc(int curr)
{
    mark[curr] = true;
    for (int i = 0; i < graph[curr].size(); i++)
    {
        int v = graph[curr][i];
        GlobalMax = 0;
        (calcMax((v), 1));
        chainLengths[chainSz++] = GlobalMax;
    }
    mark[curr] = false;

    memset(OMG, 0, sizeof(OMG));
    for (int i = 0; i < chainSz; i++)
        OMG[chainLengths[i]]++;

    for (int i = MAXK - 2; i >= 0; i--)
        OMG[i] += OMG[i + 1];

    int sz = chainSz;
    //msg(sz);
    for (int len = 1; len <= k; len++)
    {
        if (k % len != 0) continue;
        //msg(OMG[len]); msg(len);
        ans += choose[OMG[len]][k / len];
        if (ans >= MOD) ans -= MOD;
    }
}

int main()
{
    cin.sync_with_stdio(0); cin.tie(0);
    doPascal();
    //freopen("ss.in", "r", stdin);
    cin >> n >> k;
    k--;
    for (int i = 0; i < n - 1; i++)
    {
        int u, v;
        cin >> u >> v;
        graph[u].push_back(v);
        graph[v].push_back(u);
    }

    for (int i = 1; i <= n; i++)
    {
        for (int j = 0; j < resetSz; j++)
        {
            mark[toReset[j]] = false;
        }
        chainSz = 0; resetSz = 0;
        calc(i);
    }

    cout << ans << endl;

    return 0;
}
/**
14 7
1 2
2 9
1 3
3 8
8 10
8 11
8 12
8 13
8 14
1 4
4 7
1 5
5 6
*/
