#include <iostream>
#include <cstdio>
#include <set>
#include <map>
#include <queue>
#include <vector>
#include <string>
#include <cstring>
#include <cmath>
#include <ctime>
#include <algorithm>
#define msg(__var) cerr << #__var << " = " << __var << endl
using namespace std;

const long long INF = 2e18;

int xs, ys, xt, yt, n;
int sz[12224];
long long polyX[12224][20];
long long polyY[12224][20];

inline long long sqr(long long x)
{
    return (x * x);
}

long long dist(long long xs, long long ys, long long xt, long long yt)
{
    return (sqr(xs - xt) + sqr(ys - yt));
}

long long tempX[20], tempY[20], currSz;

bool in(long long x, long long y)
{
    long long polyArea = 0;
    tempX[currSz] = tempX[0]; tempY[currSz] = tempY[0];
    for (int i = 0; i < currSz; i++)
    {
        polyArea += tempX[i] * tempY[i + 1] - tempX[i + 1] * tempY[i];
        //msg(tempX[i] * tempY[i + 1] - tempX[i + 1] * tempY[i]);
    }

    long long sumTriArea = 0;
    for (int i = 0; i < currSz; i++)
        sumTriArea += abs(tempX[i + 1] * (y - tempY[i]) - x * (tempY[i + 1] - tempY[i]) + tempX[i] * (tempY[i + 1] - y));

    //msg(sumTriArea);
    //msg(polyArea);
    return (abs(sumTriArea) == abs(polyArea));
}

int main()
{
    /*currSz = 4;
    tempX[0] = 1; tempY[0] = 1;
    tempX[1] = -1; tempY[1] = 1;
    tempX[2] = -1; tempY[2] = -1;
    tempX[3] = 1; tempY[3] = -1;
    cout << (in(1, 1)) << endl;*/
    cin.sync_with_stdio(0); cin.tie(0);
    //freopen("ss.in", "r", stdin);

    cin >> xs >> ys >> xt >> yt;
    cin >> n;
    for (int i = 0; i < n; i++)
    {
        cin >> sz[i];
        for (int j = 0; j < sz[i]; j++)
            cin >> polyX[i][j] >> polyY[i][j];
    }

    int ans = 0, iter = -1;
    while ((xs != xt || ys != yt)) // GREEEEEEEEDY
    {
        ans++;
        iter++;
        if (iter == n) iter = 0;

        currSz = sz[iter];
        tempX[20], tempY[20];
        for (int i = 0; i < currSz; i++)
        {
            tempX[i] = polyX[iter][i] + xs;
            tempY[i] = polyY[iter][i] + ys;
        }
        //msg(xs); msg(ys);
        if (in(xt, yt)) break;

        long long MinDist = INF;
        int pos;
        for (int i = 0; i < currSz; i++)
        {
            long long D = dist(tempX[i], tempY[i], xt, yt);
            if (D < MinDist)
            {
                pos = i;
                MinDist = D;
            }
        }
        xs = tempX[pos]; ys = tempY[pos];
        /*msg(xs); msg(ys);
        return 0;*/
    }
    cout << ans << endl;
    return 0;
}

