#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>

using namespace std;
const int maxK = 10000 + 5;
const int maxT = 10 + 2;

struct vector
{
    double x, y;
    vector() { x = 0; y = 0; }
    vector(double xx, double yy) { x = xx; y = yy; }
    vector operator-(vector v) { return vector(x-v.x, y-v.y); }
    vector operator+(vector v) { return vector(x+v.x, y+v.y); }
    double operator*(vector v) { return x*v.y - y*v.x; }
    vector operator*(double a) { return vector(x*a, y*a); }
    double sqLength() { return x*x + y*y; }
    void print() { printf("[%.2lf, %.2lf]\n", x, y); }
    double operator/(vector v) { return x*v.x + y*v.y; } // dot product
};

struct polygon
{
    int n;
    vector point[maxT];
};

int n, k;
polygon p[maxK];
vector start, finish;

bool finishInPolygon(int k)
{
    vector fin = finish - start;
    int i = 1;
    while(i < p[k].n && (p[k].point[i]-p[k].point[i-1])*(fin-p[k].point[i-1]) >= 0)
    {
        ++i;
    }
    if(i < p[k].n) return false;
    return (p[k].point[0]-p[k].point[i-1])*(fin-p[k].point[i-1]) >= 0;
}

vector cloasestToFinishInPolygon(int k)
{
    double h, dl, minL;
    vector d, min, fin, curr;

    curr = p[k].point[0] - p[k].point[p[k].n-1];
    fin = finish - start;
    fin = fin - p[k].point[p[k].n-1];

    h = (curr*fin)*(curr*fin)/curr.sqLength();
    dl = fin.sqLength()-h;
    d = curr*sqrt(dl/curr.sqLength());
    double pom = (curr/d)/sqrt(curr.sqLength()*d.sqLength());
    if(pom < 0 || pom > 1 || d.sqLength() > curr.sqLength())
    {
        double l1 = fin.sqLength(), l2 = (fin-curr).sqLength();
        if(l1 < l2)
        {
            d.x = 0; d.y = 0;
            dl = l1;
        }
        else
        {
            d = curr;
            dl = l2;
        }
    }
    d = d + p[k].point[p[k].n-1];

    min = d;
    minL = h;

    for(int i = 1; i < p[k].n; ++i)
    {
        curr = p[k].point[i] - p[k].point[i-1];
        fin = finish - start;
        fin = fin - p[k].point[i-1];

        h = (curr*fin)*(curr*fin)/curr.sqLength();
        dl = fin.sqLength()-h;
        d = curr*sqrt(dl/curr.sqLength());
        double pom = (curr/d)/sqrt(curr.sqLength()*d.sqLength());
        if(pom < 0 || pom > 1 || d.sqLength() > curr.sqLength())
        {
            double l1 = fin.sqLength(), l2 = (fin-curr).sqLength();
            if(l1 < l2)
            {
                d.x = 0; d.y = 0;
                h = l1;
            }
            else
            {
                d = curr;
                h = l2;
            }
        }
        d = d + p[k].point[i-1];

        if(h < minL)
        {
            minL = h;
            min  = d;
        }
    }
    min = min + start;
    return min;
}

int main()
{
    scanf("%lf%lf%lf%lf", &start.x, &start.y, &finish.x, &finish.y);
    scanf("%d", &n);
    for(int i = 0; i < n; ++i)
    {
        scanf("%d", &p[i].n);
        for(int j = 0; j < p[i].n; ++j)
        {
            scanf("%lf%lf", &p[i].point[j].x, &p[i].point[j].y);
        }
    }
    int k = 0;
    while(!finishInPolygon(k%n))
    {
        start = cloasestToFinishInPolygon(k%n);
        ++k;
    }
    printf("%d\n", k+1);
    return 0;
}
