#include <iostream>
#include <cstdio>
#include <algorithm>

using namespace std;

const int N = 100005;

struct tree
{
    int h;
    long long x, start_x;
    long long d;
} ;

bool tree_lt(tree a, tree b) { return a.h < b.h; }
bool tree_gt(tree a, tree b) { return a.h > b.h; }
bool tree_d_lt(tree a, tree b) { return a.d < b.d; }

int n;
tree trees[N];

bool point_lt(int a, int b) { return trees[a].d < trees[b].d; }

int main()
{
    //freopen("test.in", "r", stdin);

    scanf("%i", &n);
    for(int i = 0; i < n; i++)
        scanf("%lld %i", &trees[i].start_x, &trees[i].h);

    int small = 0;
    for(int i = 0; i < n; i++)
        if(trees[i].h < trees[small].h)
            small = i;

    sort(trees, trees + small, tree_gt);
    sort(trees + small + 1, trees + n, tree_lt);

    trees[0].x = 0;
    for(int i = 1; i < n; i++)
        trees[i].x = trees[i - 1].x + max(trees[i].h, trees[i - 1].h);
    for(int i = 0; i < n; i++)
        trees[i].d = trees[i].x - trees[i].start_x;

    sort(trees, trees + n, tree_d_lt);

    long long free = 0;
    for(int i = 0; i < n; i++) free += trees[i].d;

    long long res = -n * trees[0].d + free;
    for(int i = 0; i < n; i++)
    {
        free -= 2 * trees[i].d;
        res = min(res, (-n + 2 * (i + 1)) * trees[i].d + free);
    }

    printf("%lld\n", res);

    return 0;
}
