#include <iostream>
#include <algorithm>
#include <cstdio>

using namespace std;

const int N = 20005;

// ----------

struct node
{
    int v, price, len, i;
    node *next;
    node(int ii, int vv, node *n, int pp, int ll) { i = ii; v = vv; next = n; price = pp; len = ll; }
} ;

node *graph[N];

void add_edge(int i, int a, int b, int p, int l)
{
    graph[a] = new node(i, b, graph[a], p, l);
    graph[b] = new node(i, a, graph[b], p, l);
}

void destroy_graph()
{
    for(int i = 0; i < N; i++)
        for(node *j = graph[i]; j; )
        {
            node *tmp = j->next;
            delete j;
            j = tmp;
        }
    for(int i = 0; i < N; i++)
        graph[i] = NULL;
}

// ----------

int n, m;

bool done[N];
void solve_tree(int curr)
{
    for(node *i = graph[curr]; i; i = i->next)
        if(!done[i->v])
        {
            done[i->v] = true;
            printf("%i ", i->i);
            solve_tree(i->v);
        }
}

const int M = 200005;

struct edge
{
     int u, v;
     int len, i;
     bool operator<(edge a) const { return len < a.len; }
} ;

edge edges[M];
int n_e;

// ----------

int set[N], rank[N];

void init(int n)
{
    for(int i = 0; i < n; i++) set[i] = i;
}

int find(int x)
{
    if(set[x] == x) return x;
    else return set[x] = find(set[x]);
}

void join(int a, int b)
{
    a = find(a);
    b = find(b);
    if(a == b) return;
    if(rank[a] < rank[b]) set[a] = b;
    else if(rank[b] < rank[a]) set[b] = a;
    else
    {
        set[a] = b;
        rank[b]++;
    }
}

// ----------

void mst()
{
    for(int i = 0; i < n; i++)
        for(node *j = graph[i]; j; j = j->next)
            if(j->v > i)
            {
                edges[n_e].u = i;
                edges[n_e].v = j->v;
                edges[n_e].len = j->price;
                edges[n_e].i = j->i;
                n_e++;
            }

    sort(edges, edges + n_e);
    m = 0; destroy_graph();
    init(n);

    for(int i = 0; i < n_e; i++)
        if(find(edges[i].u) != find(edges[i].v))
        {
            join(edges[i].u, edges[i].v);
            m++;
            add_edge(edges[i].i, edges[i].u, edges[i].v, 0, 0);
        }
}

int main()
{
    scanf("%i %i", &n, &m);
    for(int i = 0; i < m; i++)
    {
        int a, b, p, l;
        scanf("%i %i %i %i", &a, &b, &p, &l);
        a--; b--;
        add_edge(i + 1, a, b, p, l);
    }
    if(m != n - 1)
    {
        if(n == 3 && m == 3) printf("2\n3 1\n");
        else
            // lupicemo MST, pa sta bude
            mst();
    }
    printf("%i\n", m);
    done[0] = true;
    solve_tree(0);

    destroy_graph();
    return 0;
}
