#include <iostream>
#include <cstdio>

using namespace std;

const int MOD = 1000000007;
const int N = 15560;
const int K = 205;
const int M = 25; // max broj parova (d, n) takvih da d * n + 1 = k

// ----------
// tree

int v[2 * N], prev[2 * N], last[2 * N];
int n, n_e;

void init(int n)
{
    for(int i = 0; i < 2 * n; i++)
        last[i] = -1;
}

void add_edge(int a, int b)
{
    v[n_e] = b;
    prev[n_e] = last[a];
    last[a] = n_e;
    n_e++;
}

int k;
long long d[N][K]; // d[i][j] = broj cvorova na rastojanju j od i

int k_d[M], k_n[M];
int n_k;

void calc_kdn()
{
    for(int i = 3; i < k; i++)
        if((k - 1) % i == 0)
        {
            k_n[n_k] = i;
            k_d[n_k] = (k - 1) / i;
            n_k++;
        }
}

void calc_d()
{
    for(int i = 0; i < n; i++)
    {
        d[i][0] = 1;
        d[i][1] = 0;
        for(int j = last[i]; j != -1; j = prev[j])
            d[i][1]++;
    }

    for(int j = 2; j <= k; j++)
        for(int i = 0; i < n; i++)
        {
            d[i][j] = 0;
            for(int k = last[i]; k != -1; k = prev[k])
                d[i][j] += d[v[k]][j - 1] - d[i][j - 2];
        }
}

long long r[2 * N][K]; // kompresovano: R[u][n][x] = broj paukova sa nekom trenutnom duzinom d, sa centrom u, koristeci prvih x suseda u
                 // R[start[u] + x][n] = broj paukova sa centrom u, prvih x suseda u, n grana
int start[N]; // gde pocinje r za i-ti cvor

void calc_start()
{
    for(int i = 0; i < n; i++)
    {
        start[i + 1] = start[i] + 1;
        for(int j = last[i]; j != -1; j = prev[j])
            start[i + 1]++;
    }
}

int calc_r(int dd, int nn) // za duzinu dd, grana nn
{
    //printf("calc_r(%i, %i)\n", dd, nn);
    for(int i = 0; i < 2 * n; i++)
        for(int j = 0; j < k; j++)
            r[i][j] = 1;
    for(int curr_n = 1; curr_n <= nn; curr_n++)
        for(int u = 0; u < n; u++)
        {
            r[start[u]][curr_n] = 0;
            for(int curr = last[u], x = 1; curr != -1; curr = prev[curr], x++)
                r[start[u] + x][curr_n] = (r[start[u] + x - 1][curr_n] +
                                          (long long)(d[v[curr]][dd - 1] - d[u][dd - 2]) * r[start[u] + x - 1][curr_n - 1]) % MOD;
        }

    /*for(int i = 0; i < n; i++)
    {
        printf("%i:\n", i);
        for(int curr = last[i], x = 1; curr != -1; curr = prev[curr], x++)
        {
            printf("  %i: ", v[curr]);
            for(int j = 0; j <= nn; j++)
                printf("%2i", r[start[curr] + x][j]);
            printf("\n");
        }
        printf("\n");
    }*/

    int res = 0;
    for(int u = 0; u < n; u++)
    {
        res += r[start[u + 1] - 1][nn];
        if(res >= MOD) res -= MOD;
    }
    if(res < 0) return 0;
    return res;
}

int gcd(int a, int b)
{
    if(a < b) swap(a, b);
    while(b)
    {
        a = a % b;
        swap(a, b);
    }
    return a;
}

int bin[K];
int bin_coef(int a, int b) // od a odaberi b
{
    //printf("BC: %i %i\n", a, b);
    if(a < b) return 0;
    for(int i = 0; i < b; i++) bin[i] = a - i;
    for(int i = 1; i <= b; i++)
    {
        int x = i;
        for(int j = 0; j < b && x > 1; j++)
        {
            int g = gcd(bin[j], x);
            bin[j] /= g;
            x /= g;
        }
    }
    long long res = 1;
    for(int i = 0; i < b; i++)
        res = (res * bin[i]) % MOD;
    return res;
}

int calc_one(int nn)
{
    int res = 0;
    for(int i = 0; i < n; i++)
    {
        int cnt = 0;
        for(int j = last[i]; j != -1; j = prev[j]) cnt++;
        res += bin_coef(cnt, nn);
        if(res >= MOD) res -= MOD;
    }
    if(res < 0) return 0;
    return res;
}


int main()
{
    //freopen("test.in", "r", stdin);
    scanf("%i %i", &n, &k);
    init(n);
    for(int i = 0; i < n - 1; i++)
    {
        int a, b;
        scanf("%i %i", &a, &b);
        a--; b--;
        add_edge(a, b);
        add_edge(b, a);
    }

    calc_kdn();
    calc_d();
    calc_start();
    int res = 0;
    for(int i = 0; i < n_k; i++)
    {
        if(k_d[i] == 1) res += calc_one(k_n[i]);
        else res += calc_r(k_d[i], k_n[i]);
        if(res >= MOD) res -= MOD;
    }
    /*for(int i = 0; i < n; i++)
        for(int j = 0; j <= k; j++)
            ("D[%i][%i] = %i\n", i, j, d[i][j]);*/

    printf("%i\n", res % MOD);

    return 0;
}
