#include <iostream>
#include <set>
#include <algorithm>
#include <cstdio>

const int N = 353550;
int a[N];
int n;

using namespace std;

// ----------

unsigned long long count[N];

void solve_50()
{
    for(int i = 1; i <= n; i++)
        ::count[i] = ::count[i - 1] ^ (1 << a[i]); // stupid STL
    sort(::count, ::count + n + 1);

    long long res = 0, cnt = 1;
    unsigned long long curr = 0;
    for(int i = 1; i <= n; i++)
        if(::count[i] == curr) cnt++;
        else
        {
            res += cnt * (cnt - 1) / 2;
            cnt = 1;
            curr = ::count[i];
        }
    res += cnt * (cnt - 1) / 2;

    printf("%lld\n", res);
}

// ----------

const int A = 550 / 32;

struct entry
{
    unsigned cnt[A];
    long long num;
    bool const operator<(entry a) const
    {
        for(int i = 0; i < A; i++)
            if(cnt[i] != a.cnt[i])
                return cnt[i] < a.cnt[i];
        return false;
    }
} ;

void show(entry e)
{
    printf("%4i: ", e.num);
    for(int i = 0; i < 4; i++) printf("%u ", e.cnt[i]);
    printf("\n");
}

set<entry> entries;

void solve_85()
{
    entry curr;
    for(int i = 0; i < A; i++)
        curr.cnt[i] = 0;
    curr.num = 1;
    entries.insert(curr);
    for(int i = 1; i <= n; i++)
    {
        curr.cnt[a[i] >> 5] ^= 1 << (a[i] & 31);
        curr.num = 1;
        set<entry>::iterator pos = entries.find(curr);
        if(pos == entries.end())
            entries.insert(curr);
        else
        {
            curr = *pos;
            entries.erase(pos);
            curr.num++;
            entries.insert(curr);
        }
    }
    long long res = 0;
    for(set<entry>::iterator pos = entries.begin(); pos != entries.end(); pos++)
    {
        res += pos->num * (pos->num - 1) / 2;
        //show(*pos);
    }
    printf("%lld\n", res);
}

// ----------

void panic()
{
    //printf("System error 5\n");
    printf("0");
}

// ----------

int main()
{
    //freopen("test.in", "r", stdin);
    scanf("%i", &n);
    for(int i = 1; i <= n; i++)
        scanf("%i", &a[i]);

    int max_elem = -1;
    for(int i = 0; i < n; i++)
        max_elem = std::max(a[i], max_elem);

    if(max_elem < 60) solve_50();
    else if(max_elem < 540) solve_85();
    else panic();

    return 0;
}
