#include <iostream>
#include <cstdio>
#include <algorithm>

using namespace std;

const int N = 10005;
const int T = 12;

int n;
int p_n[N]; // broj temena
int x[N][T], y[N][T];

struct point
{
    long long x, y;
} ;

struct polygon
{
    int n;
    point a[N * T];
} ;

void add_points(polygon &p, int x[], int y[], int n)
{
    for(int i = 0; i < p.n; i++)
    {
        for(int j = 1; j < n; j++)
        {
            p.a[i + p.n * j].x = p.a[i].x + x[j];
            p.a[i + p.n * j].y = p.a[i].y + y[j];
        }
        p.a[i].x += x[0];
        p.a[i].y += y[0];
    }
    p.n = p.n * n;

    n = 1;
    for(int i = 1; i < p.n; i++)
        if(p.a[i].x != p.a[i - 1].x || p.a[i].y != p.a[i - 1].y) p.a[n++] = p.a[i];
    p.n = n;
}

int null_x, null_y;

bool point_lt(point a, point b)
{
    int res = (a.x - null_x) * (b.y - null_y) - (a.y - null_y) * (b.x - null_x);
    if(res == 0)
    {
        if(a.x == b.x && a.x == null_x) return (b.y < null_y) == (a.y < b.y);
        else return (b.x < null_x) == (a.x < b.x);
    }
    return res > 0;
}

bool ok(point a, point b, point c)
{
    int prod = (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
    if(prod == 0) return false;
    return prod > 0;
}

long long vec_prod(point a, point b, point c)
{
    return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
}

void delinearise(polygon &p)
{
    int n = 2;
    for(int i = 2; i < p.n; i++)
        if(vec_prod(p.a[0], p.a[n - 1], p.a[i]) != 0)
            p.a[n++] = p.a[i];
    p.n = n;
}

point p_stack[N * T];
void make_hull(polygon &p)
{
    for(int i = 1; i < p.n; i++)
        if(p.a[i].x == p.a[0].x ? p.a[i].y < p.a[0].y : p.a[i].x < p.a[0].y)
            swap(p.a[i], p.a[0]);
    null_x = p.a[0].x; null_y = p.a[0].y;
    sort(p.a + 1, p.a + p.n, point_lt);
    delinearise(p);

//    for(int i = 0; i < p.n; i++) printf("%4i%4i\n", p.a[i].x, p.a[i].y); printf("\n");

    int n_s = 3;
    p_stack[0] = p.a[0]; p_stack[1] = p.a[1]; p_stack[2] = p.a[2];
    p.a[p.n] = p.a[0];
    for(int i = 3; i <= p.n; i++)
    {
        #define TOP p_stack[n_s - 1]
        #define PREV p_stack[n_s - 2]
        #define CURR p.a[i]
        while(!ok(PREV, TOP, CURR)) n_s--;
        p_stack[n_s++] = CURR;
    }

    p.n = n_s - 1;
    for(int i = 0; i < p.n; i++)
        p.a[i] = p_stack[i];
}

polygon poly;

bool point_in_m(polygon &p, int mult, int x, int y)
{
    for(int i = 0; i < p.n; i++)
        { p.a[i].x *= mult; p.a[i].y *= mult; }

    point pnt; pnt.x = x; pnt.y = y;
    bool res = vec_prod(p.a[p.n - 1], p.a[0], pnt) >= 0;
    for(int i = 0; i < p.n - 1 && res; i++)
        if(vec_prod(p.a[i], p.a[i + 1], pnt) < 0)
            res = false;

    for(int i = 0; i < p.n; i++)
        { p.a[i].x /= mult; p.a[i].y /= mult; }
    return res;
}

int main()
{
    //freopen("test.in", "r", stdin);

    int source_x, source_y, dest_x, dest_y;
    scanf("%i %i %i %i", &source_x, &source_y, &dest_x, &dest_y);
    if(source_x == dest_x && source_y == dest_y)
    {
        printf("0\n");
        return 0;
    }
    scanf("%i", &n);
    for(int i = 0; i < n; i++)
    {
        scanf("%i", &p_n[i]);
        for(int j = 0; j < p_n[i]; j++)
            scanf("%i %i", &x[i][j], &y[i][j]);
    }

    for(int i = 0; i < p_n[0]; i++)
    {
        poly.a[i].x = x[0][i];
        poly.a[i].y = y[0][i];
    }
    poly.n = p_n[0];
    if(n == 1) make_hull(poly); // don't ask
    //for(int i = 0; i < poly.n; i++) printf("%3i%3i\n", poly.a[i].x, poly.a[i].y); printf("\n");

    for(int i = 1; i < n; i++)
    {
        add_points(poly, x[i], y[i], p_n[i]);
        //for(int i = 0; i < poly.n; i++) printf("%3i%3i\n", poly.a[i].x, poly.a[i].y); printf("\n");
        make_hull(poly);
        //for(int i = 0; i < poly.n; i++) printf("%3i%3i\n", poly.a[i].x, poly.a[i].y); printf("\n");
        //printf("----\n\n");
    }
//    for(int i = 0; i < poly.n; i++) printf("%3i%3i\n", poly.a[i].x, poly.a[i].y);
    dest_x -= source_x; dest_y -= source_y;
    if(point_in_m(poly, 1, dest_x, dest_y))
    {
        for(int i = 0; i < p_n[0]; i++)
        {
            poly.a[i].x = x[0][i];
            poly.a[i].y = y[0][i];
        }
        poly.n = p_n[0];
        for(int i = 1; i <= n; i++)
        {
            add_points(poly, x[i], y[i], p_n[i]);
            make_hull(poly);
            if(point_in_m(poly, 1, dest_x, dest_y))
            {
                printf("%i\n", i);
                return 0;
            }
        }
    }
    else
    {
        int left = 1, right = 1000000000; // recimo
        while(right - left > 1)
        {
            int mid = (right + left) / 2;
            if(point_in_m(poly, mid, dest_x, dest_y))
                right = mid;
            else left = mid;
        }
//        for(left = 1; !point_in_m(poly,left,dest_x,dest_y); left++) ;
//printf("%i\n", left);
        while(point_in_m(poly, left, dest_x, dest_y)) left--;
        int res = left * n;
        for(int i = 0; i < poly.n; i++)
        {
            poly.a[i].x *= left;
            poly.a[i].y *= left;
        }
        for(int i = 0; i < n; i++)
        {
            add_points(poly, x[i], y[i], p_n[i]);
            make_hull(poly);
            res++;
            if(point_in_m(poly, 1, dest_x, dest_y))
            {
                printf("%i\n", res);
                return 0;
            }
        }
    }

    return 0;
}
