#include <cstdio>
#include <cstdlib>
#include <algorithm>
#include <cstring>

using namespace std;

#define MAXIM 60000
#define POMODULU 1000000007

struct lista
{
    int br;
    lista *next;
};

struct listaLL
{
    long long br;
    listaLL *next;
};

struct og
{
    int duz;
    int smerDolaska;
    og *next;
};
struct sg
{
    int duz;
    int drugaGlava;
    sg *next;
};

struct cvor
{
    int brGrana;
    lista *grane;

    int brObicnihGrana;
    og *obicneGrane;

    int brSpecijalnihGrana;
    sg *specijalneGrane;
};

int n,k;
cvor a[MAXIM];
bool dali[MAXIM];

lista* listaGlava;

void saberi(int i);
void izmedjuDva(int glava, int smer);

bool imenilac[500];

long long kolikoPutaMozeBez(int glava, int duzG, int glavaZaIzbeg)
{
    long long razG = 0;
    long long razN = 1;
    for (og* i = a[glava].obicneGrane; i != 0; i = i->next)
        if (i->duz >= duzG)
            razG++;

    for (sg* i = a[glava].specijalneGrane; i != 0; i = i->next) if (i->drugaGlava != glavaZaIzbeg)
    {
        int duzina = duzG - (i->duz);
        if (duzina > 0)
        {
            long long tmp = kolikoPutaMozeBez(i->drugaGlava, duzina, glava);
            if (tmp > 0)
            {
                razN *= tmp;
                if (razN > POMODULU)
                    razN -= POMODULU;
                if (razN > POMODULU)
                    razN %= POMODULU;
                razG++;
            }
        } else
        {
            razG++;
        }
    }

    return (razG*razN)%POMODULU;
}

long long kolikoPutaMoze(int glava, int brG, int duzG)
{
    int razG = 0;
    long long razN = 1;
    for (og* i = a[glava].obicneGrane; i != 0; i = i->next)
        if (i->duz >= duzG)
            razG++;

    for (sg* i = a[glava].specijalneGrane; i != 0; i = i->next)
    {
        int duzina = duzG - (i->duz);
        if (duzina > 0)
        {
            long long tmp = kolikoPutaMozeBez(i->drugaGlava, duzina, glava);
            if (tmp > 0)
            {
                razN *= tmp;
                if (razN > POMODULU)
                    razN -= POMODULU;
                if (razN > POMODULU)
                    razN %= POMODULU;
                razG++;
            }
        } else
        {
            razG++;
        }
    }

    if (razG <= 3)
        return 0;
    if (razG < brG)
        return 0;

    long long brojilac = 1;

    memset(imenilac, 0, sizeof(imenilac));

    int len = 0;

    for (int i=1; i<=brG; i++)
    {
        long long tmp = razG--;

        for (int j=brG; j>1; j--)
        if (!imenilac[j] && (tmp%j == 0))
        {
            tmp /= j;
            imenilac[j] = true;
        }

        brojilac = (brojilac*tmp)%POMODULU;
    }

    return (brojilac*razN)%POMODULU;
}

int main()
{
    //freopen("ulaz.txt", "r", stdin);
    scanf("%d %d", &n, &k);

    for (int i=1; i<n; i++)
    {
        lista* p = new lista();
        lista* q = new lista();
        scanf("%d %d", &p->br, &q->br);
        a[p->br].brGrana++;
        a[q->br].brGrana++;

        p->next = a[q->br].grane;
        q->next = a[p->br].grane;

        a[q->br].grane = p;
        a[p->br].grane = q;
    }


    for (int i=1; i<=n; i++)
    {
        if (a[i].brGrana == 1)
            saberi(i);
    }

    for (int i=1; i<=n; i++)
    {
        if (a[i].brGrana > 2)
        {
            lista* o = new lista();
            o->br = i;
            o->next = listaGlava;
            listaGlava = o;

            for (lista* p = a[i].grane; p != 0; p = p->next)
                if (!dali[p->br])
                    izmedjuDva(i, p->br);
        }
    }

    long long ukupno = 0;

    for (int trenBGran=3; trenBGran<=k; trenBGran++) if ((k-1)%trenBGran == 0)
    {
        int duzGran = (k-1)/trenBGran;
        for (lista* trenG = listaGlava; trenG != 0; trenG = trenG->next)
        {
            long long tren = kolikoPutaMoze(trenG->br, trenBGran, duzGran);

            //printf("Iz glave %d, duzina grane %d, mozemo napraviti: %d\n", trenG->br, duzGran, tren);

            ukupno += tren;
        }
    }

    printf("%lld\n", ukupno);
/*
    for (int i=1; i<=n; i++)
    if (a[i].brGrana > 2)
    {
        printf("SA CVOROM %d su povezani:\n", i);

        for (og* p = a[i].obicneGrane; p != 0; p = p->next)
        {
            printf("\t %d duzine %d\n", p->smerDolaska, p->duz);
        }

        for (sg* p = a[i].specijalneGrane; p != 0; p = p->next)
        {
            printf("\t\t GLAVA %d duzine %d\n", p->drugaGlava, p->duz);
        }
    }
*/

    return 0;
}

void izmedjuDva(int glava, int rep)
{
    int prosli = glava;
    int suma = 1;

    while (a[rep].brGrana == 2)
    {
        suma++;

        for (lista* p = a[rep].grane; p != 0; p = p->next)
        {
            if (p->br != prosli)
            {
                prosli = rep;
                rep = p->br;
                break;
            }
        }
    }

    a[glava].brSpecijalnihGrana++;
    sg* p = new sg();
    p->next = a[glava].specijalneGrane;
    p->duz = suma;
    p->drugaGlava = rep;
    a[glava].specijalneGrane = p;
}

void saberi(int i)
{
    int zbir = 1;

    int g = a[i].grane->br;
    int prosli = i;

    while (a[g].brGrana == 2)
    {
        for (lista *p = a[g].grane; p!=0; p = p->next)
            if (p->br != prosli)
            {
                prosli = g;
                g = p->br;
                break;
            }
        zbir++;
    }

    dali[prosli] = true;

    a[g].brObicnihGrana++;
    og* p = new og();
    p->next = a[g].obicneGrane;
    p->duz = zbir;
    p->smerDolaska = prosli;
    a[g].obicneGrane = p;
}




















