/*
    Marko Bakovic, Delta3
    Srpska Informaticka Olimpijada
    Problem 4. Sekvoje
*/

#include <cstdio>
#include <algorithm>
#include <iostream>

using namespace std;

typedef long long lld;
typedef pair < int, int > pii;

const int maxn = 1e5 + 5;

int n;

lld pos[ maxn ], sol;

pii tree[ maxn ];

bool cmp_left( pii A, pii B )
{
    return A.second > B.second;
}

bool cmp_right( pii A, pii B )
{
    return A.second < B.second;
}

lld get( lld x, lld y )
{
    if ( x + y < 0LL ) return -( x + y );
    return ( x + y );
}

int main()
{
    scanf( "%d", &n );
    int idx = -1;
    for ( int i = 0; i < n; i++ )
    {
        scanf( "%d %d", &tree[ i ].first, &tree[ i ].second );
        if ( idx == -1 || tree[ idx ].second > tree[ i ].second ) idx = i;
    }

    sort( tree, tree + idx, cmp_left );
    sort( tree + idx + 1, tree + n, cmp_right );
    lld curr = 0LL;
    pos[ 0 ] = lld( -tree[ 0 ].first );
    for ( int i = 1; i < n; i++ )
    {
        pos[ i ] = curr + max( lld( tree[ i ].second ), lld( tree[ i - 1 ].second ) ) - lld( tree[ i ].first );
        curr += max( lld( tree[ i ].second ), lld( tree[ i - 1 ].second ) );
    }
    sort( pos, pos + n );
    curr = -pos[ n / 2 ];
    for ( int i = 0; i < n; i++ ) sol += get( curr, pos[ i ] );

    printf( "%lld\n", sol );

    return 0;
}
