/*
    Marko Bakovic
    Srpska Informaticka Olimpijada
    Problem 6. Putarina
*/

#include <cstdio>
#include <algorithm>
#include <vector>
#include <iostream>
#include <queue>

using namespace std;

typedef pair < int, int > pii;
typedef long long lld;

const int maxn = 2e4 + 5;
const int maxm = 2e5 + 5;

struct edge
{
    int a, b, c, d, idx;
} E[ maxm ];

int n, m, father[ maxn ];

vector < pii > adj[ maxn ];
vector < int > solV;

priority_queue < pii > PQ;

lld dist[ maxn ];

void dfs( int curr, int prev )
{
    int idx = -1;
    for ( vector < pii > :: iterator it = adj[ curr ].begin(); it != adj[ curr ].end(); it++ )
        if ( it->first != prev ) dfs( it->first, curr );
        else idx = it->second;
    if ( idx != -1 ) solV.push_back( idx );
}

void solve_tree()
{
    dfs( 0, -1 );
    printf( "%d\n", solV.size() );
    for ( int i = 0; i < solV.size(); i++ ) printf( "%d ", solV[ i ] + 1 );
}

void dijkstra()
{
    for ( int i = 0; i < n; i++ ) dist[ i ] = -1LL;
    dist[ 0 ] = 0LL;
    PQ.push( make_pair( -0, 0 ) );
    while ( ! PQ.empty() )
    {
        int curr = PQ.top().second;
        PQ.pop();
        for ( vector < pii > :: iterator it = adj[ curr ].begin(); it != adj[ curr ].end(); it++ )
            if ( dist[ it->first ] == -1LL || dist[ it->first ] > dist[ curr ] + lld( E[ it->second ].d ) )
            {
                dist[ it->first ] = dist[ curr ] + E[ it->second ].d;
                PQ.push( make_pair( -dist[ it->first ], it->first ) );
            }
    }
}

bool cmp( edge A, edge B )
{
    lld costA = dist[ A.a ] + dist[ A.b ] + lld( A.c );
    costA = min( costA, 2LL * dist[ A.a ] + 2LL * lld( A.d ) + lld( A.c ) );
    costA = min( costA, 2LL * dist[ A.b ] + 2LL * lld( A.d ) + lld( A.c ) );
    lld costB = dist[ B.a ] + dist[ B.b ] + lld( B.c );
    costB = min( costB, 2LL * dist[ B.a ] + 2LL * lld( B.d ) + lld( B.c ) );
    costB = min( costB, 2LL * dist[ B.b ] + 2LL * lld( B.d ) + lld( B.c ) );
    return costA < costB;
}

int get_DSU( int A )
{
    if ( father[ A ] != A ) father[ A ] = get_DSU( father[ A ] );
    return father[ A ];
}

bool join_DSU( int A, int B )
{
    A = get_DSU( A );
    B = get_DSU( B );
    if ( A == B ) return false;
    father[ A ] = B;
    return true;
}

void kruskal()
{
    for ( int i = 0; i < m; i++ )
        if ( join_DSU( E[ i ].a, E[ i ].b ) )
        {
            adj[ E[ i ].a ].push_back( make_pair( E[ i ].b, E[ i ].idx ) );
            adj[ E[ i ].b ].push_back( make_pair( E[ i ].a, E[ i ].idx ) );
        }
}

int main()
{
    scanf( "%d %d", &n, &m );
    for ( int i = 0; i < m; i++ )
    {
        scanf( "%d %d %d %d", &E[ i ].a, &E[ i ].b, &E[ i ].c, &E[ i ].d );
        E[ i ].a--; E[ i ].b--;
        E[ i ].idx = i;
        adj[ E[ i ].a ].push_back( make_pair( E[ i ].b, i ) );
        adj[ E[ i ].b ].push_back( make_pair( E[ i ].a, i ) );
    }

    if ( m == n - 1 )
    {
        solve_tree();
        return 0;
    }

    dijkstra();
    sort( E, E + m, cmp );
    for ( int i = 0; i < n; i++ )
    {
        adj[ i ].clear();
        father[ i ] = i;
    }
    kruskal();
    dfs( 0, -1 );

    printf( "%d\n", solV.size() );
    for ( int i = 0; i < solV.size(); i++ ) printf( "%d ", solV[ i ] + 1 );

    return 0;
}
