/*
    Marko Bakovic, Delta3
    Srpska Informaticka Olimpijada
    Problem 2. Pauk
*/

#include <cstdio>
#include <algorithm>
#include <vector>
#include <cstring>
#include <cmath>

using namespace std;

typedef long long lld;

const int maxn = 15555 + 5;
const int maxpath = 66 + 5;
const lld mod = lld( 1e9 + 7 );

int n, k, x, y, idx[ maxn ];

vector < int > adj[ maxn ];

lld mark[ maxn ][ maxpath ], dp[ maxn ][ 200 + 5 ], sol;

void dfs( int curr, int prev, int depth )
{
    idx[ depth ] = curr;
    if ( depth % 2 == 0 ) mark[ idx[ depth / 2 ] ][ depth / 2 ]++;
    if ( ( depth + 1 ) / 2 <= k / 3 )
    {
        for ( vector < int > :: iterator it = adj[ curr ].begin(); it != adj[ curr ].end(); it++ )
            if ( *it != prev ) dfs( *it, curr, depth + 1 );
    }
}

void make_dp()
{
    for ( int i = 0; i <= n; i++ ) dp[ i ][ 0 ] = 1LL;
    for ( int i = 1; i <= n; i++ )
        for ( int j = 1; j <= k; j++ ) dp[ i ][ j ] = ( dp[ i - 1 ][ j ] + dp[ i - 1 ][ j - 1 ] ) % mod;
}

lld get( int node, int path )
{
    if ( k % path ) return 0LL;
    lld cnt = mark[ node ][ path ];
    if ( ! cnt ) return 0;
    int cnt_paths = k / path;
    if ( cnt_paths > adj[ node ].size() ) return 0;
    int temp = int( ceil( sqrt( cnt ) ) );
    if ( lld( temp ) * lld( temp - 1 ) != cnt ) return 0LL;
    return dp[ temp ][ cnt_paths ];
}

int main()
{
    scanf( "%d %d", &n, &k );
    for ( int i = 0; i < n - 1; i++ )
    {
        scanf( "%d %d", &x, &y );
        adj[ x - 1 ].push_back( y - 1 );
        adj[ y - 1 ].push_back( x - 1 );
    }

    for ( int i = 0; i < n; i++ ) dfs( i, -1, 0 );
    k--;
    make_dp();
    for ( int i = 1; i <= k / 3; i++ )
        for ( int j = 0; j < n; j++ ) sol = ( sol + get( j, i ) ) % mod;

    printf( "%lld\n", sol );

    return 0;
}
