/*
    Marko Bakovic, Delta3
    Srpska Informaticka Olimpijada
    Problem 3. Inforiositi
*/

#include <cstdio>
#include <algorithm>
#include <vector>

using namespace std;

typedef long long lld;
typedef pair < int, int > pii;

const int maxk = 1e4 + 5;

int xS, yS, xE, yE, s, k, x, y;

vector < pii > hull[ maxk ];

lld cross_product( pii st, pii A, pii B )
{
    return lld( A.first - st.first ) * lld( B.second - st.second ) -
           lld( A.second - st.second ) * lld( B.first - st.first );
}

bool in_hull( pii curr, int idx )
{
    for ( int i = 0; i < hull[ idx ].size(); i++ )
        if ( cross_product( hull[ idx ][ i ], hull[ idx ][ ( i + 1 ) % hull[ idx ].size() ], curr ) < 0 ) return false;
    return true;
}

lld sqr( int A )
{
    return lld( A ) * lld( A );
}

lld dist( pii A, pii B )
{
    return sqr( A.first - B.first ) + sqr( A.second - B.second );
}

pii get( pii curr, int idx )
{
    int ret = -1;
    lld min_dist;
    for ( int i = 0; i < hull[ idx ].size(); i++ )
        if ( ret == -1 || min_dist > dist( curr, hull[ idx ][ i ] ) )
        {
            ret = i;
            min_dist = dist( hull[ idx ][ i ], curr );
        }
    return hull[ idx ][ ret ];
}

int main()
{
    scanf( "%d %d %d %d", &xS, &yS, &xE, &yE );
    scanf( "%d", &k );
    for ( int i = 0; i < k; i++ )
    {
        scanf( "%d", &s );
        for ( int j = 0; j < s; j++ )
        {
            scanf( "%d %d", &x, &y );
            hull[ i ].push_back( make_pair( x, y ) );
        }
    }

    int curr = 0, sol = 1;
    while ( ! in_hull( make_pair( xE - xS, yE - yS ), curr ) )
    {
        pii point = get( make_pair( xE - xS, yE - yS ), curr );
        xS += point.first;
        yS += point.second;
        curr = ( curr + 1 ) % k;
        sol++;
    }

    printf( "%d\n", sol );

    return 0;
}
