#include <cstdio>
#include <queue>
#include <algorithm>

using namespace std;

const long long INFINITY = 1e15;

struct Vertex;
struct Edge;
struct PairForDijkstra;
struct DisjointSet;
struct EdgeForKruskal;
struct UnweightedVertex;
struct UnweightedEdge;

int N, M;
int a, b, c, d;
int solution[20002], counter = 0;

struct Vertex
{
    long long Distance;
    Edge * first;
    DisjointSet * component;
} * V[20002];

struct Edge
{
    long long C;
    long long D;
    Vertex * start;
    Vertex * ending;
    Edge * next;
};

struct PairForDijkstra
{
    Vertex * reaching;
    long long tryValue;
};

struct EdgeForKruskal
{
    int a, b;
    int originalPosition;
    long long value;
} E[200002];

struct DisjointSet
{
    int rank;
    DisjointSet * parent;
} * DS[20002];

bool operator <(PairForDijkstra A, PairForDijkstra B)
{
    return A.tryValue > B.tryValue;
}

bool operator <(EdgeForKruskal A, EdgeForKruskal B)
{
    return A.value < B.value;
}

void AddEdge(Vertex * A, Vertex * B, long long C, long long D)
{
    Edge * e = new Edge;
    e -> start = A;
    e -> ending = B;
    e -> C = C;
    e -> D = D;
    e -> next = A -> first;
    A -> first = e;
}

void ConnectVertices(Vertex * A, Vertex * B, int C, int D)
{
    AddEdge(A, B, C, D);
    AddEdge(B, A, C, D);
}

DisjointSet * Find(DisjointSet * A)
{
    if (A -> parent != A)
        A -> parent = Find(A -> parent);
    return A -> parent;
}

bool InSameSet(DisjointSet * A, DisjointSet * B)
{
    return Find(A) == Find(B);
}

void Union(DisjointSet * A, DisjointSet * B)
{
    DisjointSet * X = Find(A);
    DisjointSet * Y = Find(B);
    if (X -> rank <= Y -> rank)
    {
        X -> parent = Y;
        Y -> rank++;
    }
    else
    {
        Y -> parent = X;
        X -> rank++;
    }
}

void ComputeDijkstra(Vertex * rootVertex)
{
    priority_queue <PairForDijkstra> PQ;
    PairForDijkstra A;
    A.reaching = rootVertex;
    A.tryValue = 0;
    PQ.push(A);
    PairForDijkstra currRootOfPQ, newNodeInPQ;
    Vertex * currVertex;
    Edge * iterator;
    while (!PQ.empty())
    {
        currRootOfPQ = PQ.top();
        PQ.pop();
        currVertex = currRootOfPQ.reaching;
        currVertex -> Distance = currRootOfPQ.tryValue;
        iterator = currVertex -> first;
        while (iterator != NULL)
        {
            if (iterator -> ending -> Distance == INFINITY)
            {
                newNodeInPQ.tryValue = currVertex -> Distance + iterator -> D;
                newNodeInPQ.reaching = iterator -> ending;
                PQ.push(newNodeInPQ);
            }
            iterator = iterator -> next;
        }
    }
}

void ComputeKruskal()
{
    sort(E + 1, E + M + 1);
    for (int i = 1; i <= M; i++)
        if (!InSameSet(V[E[i].a] -> component, V[E[i].b] -> component))
        {
            Union(V[E[i].a] -> component, V[E[i].b] -> component);
            solution[N - counter - 1] = E[i].originalPosition;
            counter++;
        }
}

int main()
{
    scanf("%d %d", &N, &M);
    for (int i = 1; i <= N; i++)
    {
        V[i] = new Vertex;
        V[i] -> Distance = INFINITY;
        V[i] -> first = NULL;
        DS[i] = new DisjointSet;
        DS[i] -> rank = 1;
        DS[i] -> parent = DS[i];
        V[i] -> component = DS[i];
    }
    for (int i = 1; i <= M; i++)
    {
        scanf("%d %d %d %d", &a, &b, &c, &d);
        ConnectVertices(V[a], V[b], c, d);
        E[i].a = a;
        E[i].b = b;
        E[i].value = c;
        E[i].originalPosition = i;
    }
    printf("%d\n", N - 1);
    ComputeDijkstra(V[1]);
    for (int i = 1; i <= M; i++)
        E[i].value += V[E[i].a] -> Distance + V[E[i].b] -> Distance;
    ComputeKruskal();
    for (int i = 1; i <= N - 1; i++)
        printf("%d ", solution[i]);
    return 0;
}
