#include <cstdio>

using namespace std;

int N, K;
int x, y;
long long S, trenS;
long long solution = 0;
const long long MOD = 7+1e9;
int delilac[100];
int brojDelilaca;

struct Vertex;
struct Edge;

struct Vertex
{
    Edge * first;
} * V[20000];

struct Edge
{
    Vertex * start;
    Vertex * ending;
    Edge * next;
    Edge * reverse;
    long long sol[302];
    long long DP[302];
};

Edge * AddEdge(Vertex * A, Vertex * B)
{
    Edge * e = new Edge;
    e -> start = A;
    e -> ending = B;
    e -> next = A -> first;
    e -> sol[0] = 1;
    A -> first = e;
    return e;
}

void ConnectVertices(Vertex * A, Vertex * B)
{
    Edge * e1 = AddEdge(A, B);
    Edge * e2 = AddEdge(B, A);
    e1 -> reverse = e2;
    e2 -> reverse = e1;
}

void Rastavi(int broj)
{
    brojDelilaca = 0;
    for (int i = 1; i <= broj / 3; i++)
        if (broj % i == 0)
        {
            brojDelilaca++;
            delilac[brojDelilaca] = i;
        }
}

long long FindSS(Vertex * A, int brojCinilaca, int duzina)
{
    long long suma = 0;
    long long sumaDoSada = 0;
    Edge * e = A -> first;
    while (e != NULL)
    {
        e -> DP[1] = e -> sol[duzina - 1] + sumaDoSada;
        sumaDoSada += e -> sol[duzina - 1];
        for (int i = 2; i <= 300; i++)
            e -> DP[i] = 0;
        e = e -> next;
    }
    for (int t = 2; t <= brojCinilaca; t++)
    {
        sumaDoSada = 0;
        e = A -> first;
        while (e -> next != NULL)
        {
            e -> next -> DP[t] = (e -> DP[t] + (e -> next -> sol[duzina - 1] * e -> DP[t - 1]) % MOD) % MOD;
            e = e -> next;
        }
    }
    return e -> DP[brojCinilaca];
}

int main()
{
    scanf("%d %d", &N, &K);
    for (int i = 1; i <= N; i++)
    {
        V[i] = new Vertex;
        V[i] -> first = NULL;
    }
    for (int i = 1; i <= N - 1; i++)
    {
        scanf("%d %d", &x, &y);
        ConnectVertices(V[x], V[y]);
    }
    for (int l = 1; l <= K; l++)
        for (int j = 1; j <= N; j++)
        {
            S = 0;
            Edge * e = V[j] -> first;
            while (e != NULL)
            {
                S += e -> sol[l - 1];
                S %= MOD;
                e = e -> next;
            }
            e = V[j] -> first;
            while (e != NULL)
            {
                e -> reverse -> sol[l] = S - e -> sol[l - 1];
                e = e -> next;
            }
        }
    Rastavi(K - 1);
    for (int d = 1; d <= brojDelilaca; d++)
        for (int i = 1; i <= N; i++)
        {
            solution += FindSS(V[i], (K - 1) / delilac[d], delilac[d]);
            solution %= MOD;
        }
    printf("%lld", solution);
    return 0;
}

// dedicated to: K
