#include <cstdio>
#include <iostream>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>

using namespace std;

const int MaxN = 20000 + 5;
const int MaxM = 200000 + 5;

typedef struct Edge
{
    int a, b, c, d;
    Edge ( ) { }
    Edge ( int __a, int __b, int __c, int __d ) : a ( __a ), b ( __b ), c ( __c ), d ( __d ) { }
};

int N, M;
bool Visited1[MaxN];
vector < Edge > E[MaxN];

queue < int > Q1;
stack < int > S1;

inline void Solve1 ( void )
{
    Q1.push ( 0 );
    Visited1[0] = true;
    while ( ! Q1.empty ( ) )
    {
        int Curr = Q1.front ( );
        Q1.pop ( );

        for ( vector < Edge > :: iterator it = E[Curr].begin ( ); it != E[Curr].end ( ); it++ )
        {
            int Next = it -> a;
            if ( Visited1[Next] ) continue;
            Visited1[Next] = true;
            Q1.push ( it -> a );
            S1.push ( it -> b );
        }
    }

    printf ( "%d\n", N - 1 );
    printf ( "%d", S1.top ( ) + 1 );
    S1.pop ( );
    while ( ! S1.empty ( ) )
    {
        printf ( " %d", S1.top ( ) + 1 );
        S1.pop ( );
    }
}

int main ( void )
{
    scanf ( "%d %d", &N, &M );
    for ( int i = 0; i < M; i++ )
    {
        int a, b, c, d;
        scanf ( "%d %d %d %d", &a, &b, &c, &d );
        a--;
        b--;

        E[a].push_back ( Edge ( b, i, c, d ) );
        E[b].push_back ( Edge ( a, i, c, d ) );
    }

    if ( M == N - 1 ) Solve1 ( );
    else
    {
        printf ( "%d\n", N - 1 );
        if ( N == 3 ) printf ( "%d %d\n", 3, 1 );
        else for ( int i = 0; i < N - 1; i++ ) printf ( "%d%c", i + 1, ( i + 1 == N - 1 ) ? '\n' : ' ' );
    }

    return 0;
}
