#include <cstdio>
#include <iostream>
#include <cstdlib>

using namespace std;

typedef long long int lld;

const int MaxN = 500 + 5;
const int MaxM = 500 + 5;
const lld INF = 1LL << 60LL;

int N, M, A[MaxN][MaxM];
lld DP[MaxN][MaxM], MaxL[MaxM], MaxR[MaxM];

inline void CheckSpecialTrolololo ( void )
{
    bool AllAdd = true;
    for ( int i = 0; i < N; i++ )
        for ( int j = 0; j < M; j++ ) AllAdd &= A[i][j] >= 0;

    if ( AllAdd )
    {
        lld Ret = 0LL;
        for ( int i = 0; i < N; i++ )
            for ( int j = 0; j < M; j++ ) Ret += 1LL * A[i][j];
        cout << Ret << endl;

        exit ( 0 );
    }
}

inline lld Solve1 ( void )
{
    for ( int i = 0; i < N; i++ )
        for ( int j = 0; j < M; j++ ) DP[i][j] = 1LL * A[i][j];

    for ( int i = 0; i < N; i++ )
    {
        for ( int j = 0; j < M; j++ )
        {
            lld CurrMaxL = -INF, CurrL = 0LL, CurrMaxR = -INF, CurrR = 0LL;
            for ( int k = j - 1; k >= 0; k-- )
            {
                CurrL += A[i][k];
                if ( CurrL > CurrMaxL ) CurrMaxL = CurrL;
            }
            for ( int k = j + 1; k < M; k++ )
            {
                CurrR += A[i][k];
                if ( CurrR > CurrMaxR ) CurrMaxR = CurrR;
            }

            if ( CurrMaxL < 0LL ) CurrMaxL = 0LL;
            if ( CurrMaxR < 0LL ) CurrMaxR = 0LL;

            MaxL[j] = CurrMaxL;
            MaxR[j] = CurrMaxR;
        }

        for ( int j = 0; j < M; j++ )
        {
            lld Add = A[i][j];
            if ( i ) if ( DP[i - 1][j] >= 0LL ) Add += DP[i - 1][j];
            lld Curr = Add;
            Curr += MaxL[j] + MaxR[j];
            if ( Curr > DP[i][j] ) DP[i][j] = Curr;

            lld CurrL = 0LL, CurrR = 0LL;
            for ( int k = j - 1; k >= 0; k-- )
            {
                CurrL += A[i][k];
                if ( CurrL + Add + MaxL[k] + MaxR[j] > DP[i][k] ) DP[i][k] = CurrL + Add + MaxL[k] + MaxR[j];
            }
            for ( int k = j + 1; k < M; k++ )
            {
                CurrR += A[i][k];
                if ( CurrR + Add + MaxR[k] + MaxL[j] > DP[i][k] ) DP[i][k] = CurrR + Add + MaxR[k] + MaxL[j];
            }
        }
    }

    lld Ret = -INF;
    for ( int i = 0; i < N; i++ )
        for ( int j = 0; j < M; j++ ) if ( DP[i][j] > Ret ) Ret = DP[i][j];

    return Ret;
}

int main ( void )
{
    scanf ( "%d %d", &N, &M );
    for ( int i = 0; i < N; i++ )
        for ( int j = 0; j < M; j++ ) scanf ( "%d", &A[i][j] );

    CheckSpecialTrolololo ( );
    cout << Solve1 ( ) << endl;

    /*
    for ( int i = 0; i < N; i++ )
    {
        for ( int j = 0; j < M; j++ ) cout << DP[i][j] << " ";
        cout << endl;
    }
    */

    return 0;
}
