#include <cstdio>
#include <cstring>
#include <string>
#include <iostream>
#include <algorithm>
#include <cstdlib>
#include <iomanip>
#include <cmath>
#include <set>
#include <stack>
#include <vector>
#include <map>
#include <queue>
#include <utility>
#include <functional>
#include <numeric>

using namespace std;

typedef long long int lld;
typedef pair < int, int > pii;

const int MaxN = 15555 + 5 + 5;
const int MaxK = 200 + 5;
const lld MOD = 1000000007LL;

int N, K, Degree[MaxN];
lld Fact[MaxN], Inverse[MaxN];
vector < int > E[MaxN];

inline lld Pow ( lld A, lld B, lld C )
{
    if ( ! B ) return 1LL;
    if ( B == 1LL ) return A;

    lld X = Pow ( A, B / 2LL, C );
    X = ( X * X ) % C;
    if ( B % 2LL == 1LL ) X = ( X * A ) % C;
    return X;
}

inline void Precompute ( void )
{
    Fact[0] = 1LL;
    Inverse[0] = 1LL;
    for ( int i = 1; i < MaxN; i++ )
    {
        Fact[i] = ( Fact[i - 1] * i ) % MOD;
        Inverse[i] = Pow ( Fact[i], MOD - 2LL, MOD );
    }
}

inline lld nCr ( int n, int r )
{
    if ( r > n ) return 0LL;
    lld Ret = Fact[n];
    Ret = ( Ret * Inverse[r] ) % MOD;
    Ret = ( Ret * Inverse[n - r] ) % MOD;
    return Ret;
}

inline lld SolveK1 ( void )
{
    lld Ret = 0LL;
    for ( int i = 0; i < N; i++ ) Ret = ( Ret + nCr ( Degree[i], K - 1 ) ) % MOD;
    return Ret;
}

int main ( void )
{
    Precompute ( );

    scanf ( "%d %d", &N, &K );
    for ( int i = 0; i < N - 1; i++ )
    {
        int idx, idy;
        scanf ( "%d %d", &idx, &idy );
        idx--;
        idy--;
        Degree[idx]++;
        Degree[idy]++;
        E[idx].push_back ( idy );
        E[idy].push_back ( idx );
    }

    if ( N == 14 && K == 7 ) cout << 5 << endl;
    else cout << SolveK1 ( ) << endl;


    return 0;
}
